<?php
class Opcion {
  private $titulo;
  private $enlace;
  private $colorFondo;
  public function __construct($titulo,$enlace,$colorFondo)
  {
    $this->titulo=$titulo;
    $this->enlace=$enlace;
    $this->colorFondo=$colorFondo;
  }
  public function graficar()
  {
    echo '<a style="background-color:'.$this->colorFondo.'" href="'.$this->enlace.'">'.$this->titulo.'</a>';
  }
}

class Menu {
  private $opciones=array();
  private $direccion;
  
  public function __construct($direccion)
  {
    $this->direccion=$direccion;
  }
  
  public function insertar($opcion)
  {
    $this->opciones[]=$opcion;
  }

  private function graficarHorizontal()
  {
    for($f=0;$f<count($this->opciones);$f++)
    {
      $this->opciones[$f]->graficar();
    }
  }
  private function graficarVertical()
  {
    for($f=0;$f<count($this->opciones);$f++)
    {
      $this->opciones[$f]->graficar();
      echo '<br>';
    }
  }

  public function graficar()
  {
    if (strtolower($this->direccion)=="horizontal")
      $this->graficarHorizontal();
    else
      if (strtolower($this->direccion)=="vertical")
        $this->graficarVertical();
  }
}

$menu1=new Menu('vertical');
$opcion1=new Opcion('Google','http://www.google.com','#C3D9FF');
$menu1->insertar($opcion1);
$opcion2=new Opcion('Yahoo','http://www.yahoo.com','#CDEB8B');
$menu1->insertar($opcion2);
$opcion3=new Opcion('MSN','http://www.msn.com','#C3D9FF');
$menu1->insertar($opcion3);
$menu1->graficar();

?>